#ifndef SGTIN96_H
#define SGTIN96_H

#include "../QrfeTagId.h"

namespace GS1
{

class SGTIN96 : public QrfeTagId
{
public:
    SGTIN96();
    SGTIN96(const QByteArray& epc);
    SGTIN96(quint64 companyPrefix, quint64 itemReference, quint64 serialNumber, int filterValue, int partitionValue);

    virtual QString tagId() const;

    quint8  filter() const;
    quint8  partitionValue() const;
    quint64 companyPrefix() const;
    quint32 itemReference() const;
    quint64 serialNumber() const;

    QByteArray toEPC();

    static SGTIN96 fromEPC(const QByteArray& epc, bool* valid);

    static int getCompanyPrefixDigitCount (int partitionValue);
    static int getItemReferenceDigitCount (int partitionValue);

protected:
    static int getCompanyPrefixBitCount (int partitionValue);
    static int getItemReferenceBitCount (int partitionValue);

    static QByteArray   generateEPC ( quint64 companyPrefix, quint64 itemReference, quint64 serialNumber, int filterValue, int partitionValue );
    static bool         parsePEC ( const QByteArray& epc, quint64& companyPrefix, quint64& itemReference, quint64& serialNumber, int& filterValue, int& partitionValue );

private:
    quint8  m_filter;
    quint8  m_partitionValue;
    quint64 m_companyPrefix;
    quint32 m_itemReference;
    quint64 m_serialNumber;
};

}

#endif // SGTIN96_H
